//
//  MCPostgresDefines.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 24/08/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>


// Directory which contains the PG embedded build in the frameworks Resources folder
extern NSString*  kMCEmbeddedPostgresqlDirectory;


// Modes to use when stopping the PG server
typedef enum {
	
	kMCPGSmartServerStopMode = 1,  // Waits for all clients to disconnect - nice stop!
	kMCPGFastServerStopMode, // Kills all client connections and properly shuts down PG
	kMCPGImmediateServerStopMode // Kills PG - not nice! Will result in a recovery on restart and potential data loss
	
} MCPGServerStopMode;


// Error Domains
// There are 3 error domains
//  MCPostgresDomain - is for framework level errors
//  MCPostgresConnectionDomain - is used to wrap PG connection errors
//  MCPostgresResultDomain - is used to wrap PG query errors
// These domains had to be introduced because the error codes conflict across these 3
extern NSString*   MCPostgresDomain;
extern NSString*   MCPostgresConnectionDomain;
extern NSString*   MCPostgresResultDomain;
extern NSString*   MCPostgresBackupRestoreDomain;

// Backup/Restore notification names
extern NSString*	MCPostgresRestoreProgressNotification;
extern NSString*	MCPostgresBackupProgressNotification;
extern NSString*	MCPostgresBackupRestoreNotificationTypeKey;

// MCPostgresResultDomain Codes
typedef enum {
    MCPostgresResultLostConnectionError = 1000
} MCPostgresResultError;

// Server Error Codes
typedef enum {
	
	MCPGServerUnknownError = 1,
	
	// State Errors
	MCPGServerUnspecifiedDataPathError = 100,
	MCPGServerUninitializedDataPathError = 101,
	
	MCPGServerProcessCheckError = 200,
	
	MCPGServerProcessStartError = 300,
	MCPGServerProcessConfChangedStartError = 301,
    MCPGServerProcessSocketFolderCreateError = 302,
    MCPGServerProcessSocketFolderWritableError = 303,
	MCPGServerProcessFSyncResetRestartError = 304,
	
	MCPGServerProcessStopError = 400,
	
	MCPGServerProcessRestartError = 410,
	MCPGServerProcessRestartNotRunningError = 411,
	
	// Initialization Errors
	MCPGServerDataPathInitializationError = 500,
	MCPGServerDataPathInitializationCommandError = 501,
	MCPGServerDataPathInitializationWriteTempPasswordFileError = 502,
	MCPGServerDataPathInitializationRemoveTempPasswordFileError = 503,
	MCPGServerDataPathInitializationLogFolderNotDirectoryError = 504,
	MCPGServerDataPathInitializationLogFolderNotWritableError = 505,
	MCPGServerDataPathInitializationLogFolderCreationError = 506,
	MCPGServerDataPathInitializationBackupFolderNotDirectoryError = 507,
	MCPGServerDataPathInitializationBackupFolderNotWritableError = 508,
	MCPGServerDataPathInitializationBackupFolderCreationError = 509,
	MCPGServerDataPathInitializationAdminDatabaseCreationError = 510,
	MCPGServerDataPathInitializationConfigFileWriteError = 511,
	MCPGServerDataPathInitializationSupportFilesFolderCreationError = 512,
	MCPGServerDataPathInitializationSupportFilesFolderNotDirectoryError = 513,
    MCPGServerDataPathInitializationDataPathNotWritableError = 514,
    MCPGServerDataPathInitializationSSLError = 515,

    
    // Bulk Copy Errors
    MCPGServerBulkCopyStartOutError = 600,
    MCPGServerBulkCopyStartInError = 601,
    MCPGServerBulkCopyInProgressError = 602,
    MCPGServerBulkCopyInFinishError = 603,
    MCPGServerBulkCopyOutFinishError = 604,
	
	// Backup/Restore errors
	MCPGServerBackupError = 700,
	MCPGServerBackupFileCreatePathNotExist = 701,
	MCPGServerBackupFileCreatePathNotWritable = 702,
	MCPGServerBackupFileCreationError = 703,
	MCPGServerBackupDatabaseConnectionError = 704,
	MCPGServerBackupDatabaseQueryError = 705,
	MCPGServerBackupExistingDatabaseError = 706,
	MCPGServerBackupDropExistingDatabaseError = 707,

	// Database Creation Errors
    MCPGServerDatabaseCreationError = 800,
    MCPGServerDatabaseCreationInvalidNameError = 801,
    MCPGServerDatabaseCreationAlreadyExistsError = 802,
    MCPGServerDatabaseCreationSQLError = 803,
    MCPGServerDatabaseCreationSchemaSQLError = 804,
    
    
	// Dictionary Based API Error
	MCPGDatabaseEmptyDictionaryError = 1000,
	MCPGDatabaseMissingPrimaryKeyValueError = 1001,
	
	// User Creation Errors
	
	MCPGServerDatabaseDoesNotExist = 2000,
	MCPGUserCreationSQLError = 2001,
	MCPGUserGrantSQLError = 2002,
	
} MCPGServerError;

typedef enum {
	MCPGBackupStart = 0,
	MCPGBackupStop,
	MCPGRestoreStart,
	MCPGRestoreProgress,
	MCPGRestoreStop
} MCPGBackupRestoreProgress;

